<?php
/**
 * Plugin Name:  AC – Aria‑label veld bij Elementor‑Button
 * Description:  Een extra control (aria‑label) in de Inhoud‑tab van de Button‑widget.
 * Author:       Luc van der Heiden
 * Version:      1.0.2
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

use Elementor\Controls_Manager;
use Elementor\Element_Base;

/**
 * 1.  Control injecteren (na "section_button" in de CONTENT‑tab)
 * -------------------------------------------------------------
 */
add_action( 'elementor/init', function () {

    add_action(
        'elementor/element/button/section_button/after_section_end',
        function ( Element_Base $element ) {

            $element->start_controls_section(
                'ac_aria_section',
                [
                    'label' => __( 'Toegankelijkheid', 'ac-aria' ), 
                    'tab'   => Controls_Manager::TAB_CONTENT, // Inhoud tab
                ]
            );

            $element->add_control(
                'ac_aria_label',
                [
                    'label'       => __( 'Aria-label', 'ac-aria' ),
                    'type'        => Controls_Manager::TEXT,
                    'placeholder' => __( 'Bijv. “Lees meer over product X”', 'ac-aria' ),
                    'label_block' => true,
                ]
            );

            $element->end_controls_section();
        },
        10,
        1
    );
} );


/**
 *  2. Aria‑label op de echte <a> of <button> element plaatsen
 *  --------------------------------------------------------
 */
add_action(
	'elementor/frontend/widget/before_render',
	function ( $widget ) {

		// we zijn alleen op zoek naar button widgets
		if ( 'button' !== $widget->get_name() ) {
			return;
		}

		$settings = $widget->get_settings_for_display();
		$label    = trim( $settings['ac_aria_label'] ?? '' );

		if ( '' === $label ) {
			return;                         // als het leeg is gelaten doen we niks met het veld
		}

		// op beide mogelijke handles zetten
		foreach ( [ 'link', 'button' ] as $handle ) {
			$widget->add_render_attribute(
				$handle,
				'aria-label',
				esc_attr( $label )
			);
		}
	},
	999   // zo laat mogelijk, zodat het niet probeert iets toe te voegen aan een button die nog niet bestaat
);